#!/bin/bash
# _grepinfiles.sh
USER=$1
DOMAIN=$2
LOOKFOR=$3
TYPE=$4

if [ -z "$USER" ]
then
        echo "No Username given!"
        exit
fi

if [ -z "$DOMAIN" ]
then
        echo "No domain given!"
        exit
fi

if [ -z "$LOOKFOR" ]
then
        echo "No search patern given!"
        exit
fi

if [ -z "$TYPE" ]
then
        echo "No search type given!"
        exit
fi

case $TYPE in
        search) _TYPE=1;;
        locate) _TYPE=2;;
        *) echo "Given type is invalid!"; exit;;
esac

if [ -d "/home/$USER" ]
then

        if [ -d "/home/$USER/domains/$DOMAIN" ]
        then
                _G='EMPTY';
                if [ "$_TYPE" -eq 1 ]
                then
                        _G=$( grep -irn "${LOOKFOR}" "/home/$USER/domains/$DOMAIN/public_html" )
                fi

                if [ "$_TYPE" -eq 2 ]
                then
                        cd /home/"$USER"/domains/"$DOMAIN"
                        _G=$( find . -type f -name "${LOOKFOR}" )
                fi

                echo "$_G";
        else
                echo "/home/$USER/domains/$DOMAIN directory does not exist!";
                exit
        fi

else
        echo "/home/$USER directory does not exist!"
        exit
fi
