#!/bin/bash
# DBHOST="XXXXXXX"
# DBUSER="XXXXX"
# DBPASSWD="XXXXX"
# DBDATABASE="XXXXX"
# DBTABLE="XXXXX"
TIMEOUT="600"
LOCKPATH="/usr/local/sshdaemon/sshd_dulocks"
GETSIZE=""

echo " "

setLock() {
if [ ! -d "$LOCKPATH" ];then mkdir "$LOCKPATH";fi
LOCK="$LOCKPATH/du_$USERNAME.lock"
CURS=$(date +"%s")
if [ ! -f "$LOCK" ]
then
        echo "$CURS" > "$LOCK"
else
        OLDS=$(cat "$LOCK")
        DIFF=$((CURS-OLDS))
        if [ "$DIFF" -gt "$TIMEOUT" ]
        then
                rm -f "$LOCK"
                CURS=$(date +"%s")
                echo "$CURS" > "$LOCK"
        else
                echo "You have used this command less then 10 minutes ago for this user."
                echo "You can only run this once every 10 minutes!"
                echo "Exiting now..."
                exit
        fi
fi
}

ACTION="$1"
if [ -z "$ACTION" ]
then
        echo "No action given!"
        echo "Please use 'full', 'imap' or 'domain' as action value"
        echo "Exiting now..."
        exit
fi

case "$ACTION" in
        full)    ;;
        domain)  ;;
        imap)    ;;
        r3m_0v3L0ck5)
                echo "Removing locks!"
                rm -f $LOCKPATH/*.lock
                echo "Lock removing complete!"
                exit
        ;;
        *)
                echo "Given action value is not correct."
                echo "Please only use 'full' or 'domain' as a action value!"
                exit
        ;;
esac

USERNAME="$2"
if [ -z "$USERNAME" ]
then
        echo "No username given!"
        echo "Exiting now..."
        exit
fi

echo "You can use this command only once every 10 minutes. Please keep this in mind!"

if [ "$ACTION" == "full" ]
then
        setLock
        echo "Please do not close this page and let it run. Also do not send this command multiple times if it does not return."
        echo "Since we are going to calculate the user his home dir size this might take a while!!"
        echo " "
        GETSIZE=$( du -a -c -h -P --max-depth=2 /home/"$USERNAME" | sort -hr )
        #echo "$GETSIZE"
        echo " "
 fi

if [ "$ACTION" == "domain" ]
then
DOMAIN="$3"
if [ -z "$DOMAIN" ];then echo "No domain given on action domain. please send a domainname!";echo "Exiting now...";exit;fi
setLock

        echo "Please do not close this page and let it run. Also do not send this command multiple times if it does not return."
        echo "Since we are going to calculate the user his domain dir size this might take a while!!"
        echo " "
        GETSIZE=$( du -a -c -h -P --max-depth=2 /home/"$USERNAME"/domains/"$DOMAIN"/ --exclude="stats" --exclude="awstats" | sort -hr )
        #echo "$GETSIZE"
        echo " "
fi

if [ "$ACTION" == "imap" ]
then
DOMAIN="$3"
setLock

        if [ -z "$DOMAIN" ]
        then
                echo "No domain given on action imap. Creating a list of dirs in the imap folder!"
                echo "Please do not close this page and let it run. Also do not send this command multiple times if it does not return."
                echo "Since we are going to calculate the user his domain dir size this might take a while!!"
                echo " "
                GETSIZE=$( du -a -c -h -P --max-depth=1 /home/"$USERNAME"/imap/ | sort -hr )
                #echo "$GETSIZE"
                echo " "

        else

                echo "Please do not close this page and let it run. Also do not send this command multiple times if it does not return."
                echo "Since we are going to calculate the user his domain dir size this might take a while!!"
                echo " "
                GETSIZE=$( du -a -c -h -P --max-depth=1 /home/"$USERNAME"/imap/"$DOMAIN"/ | sort -hr )
                #echo "$GETSIZE"
                echo " "

        fi

fi

echo "$GETSIZE";

# MYSQL_PWD=$DBPASSWD mysql -h "$DBHOST" -u"$DBUSER" "$DBDATABASE" -e "INSERT INTO "$DBTABLE" (action, username, output) VALUES ('$ACTION', '$USERNAME', '$GETSIZE')"
echo "Done!"
echo " "
exit
