#/bin/bash
# Fail2ban script for client actions from sshdaemon
#
# f2b <get> <jail_name> <banip/unbanip> <ip>
#
_F2BC=$(which fail2ban-client)

HEADER() {
cat <<RESTVER

		Fail2ban script for client actions from sshdaemon 1.0

RESTVER
}

SHOWHELP() {
cat <<EOHELP

	USAGE _fail2banclient.sh [ OPTIONS ]

	-t [ Type ]
		get/set type for the action.
	-j [ Jail ]
		The f2b-JAIL you want to manage.
	-a [ Action ]
		The action that you want to do, banip or unbanip
	-i [ IP ]
		The IP you want to apply the action on.
	-h [ Help ]
		This info.

EOHELP
exit
}
if [ "$1" -eq 1 ]
then
	_TYPE="$2";
	_JAIL="$3";
	_ACTION="$4";
	_IP="$5";

else

### Start getopts code ###
while getopts :t:j:a:i:h: FLAG
do
	case "$FLAG" in
		t) _TYPE="$OPTARG";;
		j) _JAIL="$OPTARG";;
		a) _ACTION="$OPTARG";;
		i) _IP="$OPTARG";;
		h) SHOWHELP;;
		\?)  echo -e \\n"Option -$OPTARG not allowed."; exit;;
		*)  HEADER SHOWHELP;;
	esac
done
shift $((OPTIND-1))

fi

if [ -z "$_TYPE" ];then echo "Type is not set!"; SHOWHELP; fi
if [ -z "$_JAIL" ];then echo "Jail is not set!"; SHOWHELP; fi
if [ -z "$_ACTION" ];then echo "Action is not set!"; SHOWHELP; fi
if [ -z "$_IP" ];then echo "IP is not set!"; SHOWHELP; fi

case "$_TYPE" in
	set) DO_T='set';;
	*) echo "Not a valid action. Use set."; exit 1;;
esac
case "$_JAIL" in
	proftpd) DO_J='proftpd';;
	*) echo "Not a valid jailname."; exit 1;;
esac
case "$_ACTION" in
	banip) DO_A='banip';;
	unbanip) DO_A='unbanip';;
	*) echo "Not a valid action. Use banip or unbanip"; exit 1;;
esac

if [ "$DO_A" = "banip" ]
then
	echo "Banning IP $_IP";
else
	echo "Unbanning IP $_IP";
fi

$_F2BC $_TYPE $_JAIL $_ACTION $_IP


## 
