#!/bin/bash
######################################
# add domain to longertimeout haprox #
######################################

if [[ -z "$1" ]]; then echo "Sorry, no domain name given to add longer timeout."; exit 1; fi
if [[ ! -d /etc/scripts/full_hitless ]]; then echo "This server does not run haproxy."; exit 1; fi

hitlessreload() {
if [ -f /etc/scripts/full_hitless/hitlessrestart.sh ];
then
	if [ -f /var/lock/hitless.root.lock ];
	then
		echo "Sorry root is already running this command.";
	else
		touch /var/lock/hitless.root.lock;
		if [ -z "$1" ];
		then
			echo "Only reloading haproxy."
			/usr/local/sbin/haproxy -f /etc/scripts/full_hitless/haproxy.conf -c -q
			if [ "$?" != "0" ];
			then
				/usr/local/sbin/haproxy -f /etc/scripts/full_hitless/haproxy.conf -c  >> /var/log/haproy-reload.error
				echo "failed haproxy" > /etc/scripts/httpdhitless.status;
				echo "HaProxy | Error reloading haproxy. Please check.";
			else
				socat /var/run/haproxy.sock - <<< "show servers state" > /var/run/haproxy-server-state
				/bin/kill -USR2 $(cat /var/run/haproxy.pid | xargs)
				echo "HaProxy | config reloaded.";
				rm -f /usr/local/directadmin/data/.haproxy-reload
			fi
		else
			echo "No valid option given. You gave $1";
		fi
		rm -f /var/lock/hitless.root.lock;
	fi
else
	echo "Server does not support full hitless reload.";
fi
}
# export -f hitlessreload

if [[ -d /etc/scripts/full_hitless ]];
then

	if grep -q "$1" /etc/scripts/full_hitless/mapping/acl_longer_timeout_host.map
	then
		echo "Sorry, this domain is already excluded for a longer timeout period.";
		echo "This period is 30 minutes which should be enoug to run the php scripts.";
		exit 1;
	else
		echo "Adding domain $1 to a longer timeout period for haproxy.";
		echo "$1" >> /etc/scripts/full_hitless/mapping/acl_longer_timeout_host.map;
		echo "Domain $1 added to longer timeout period. This period is 30 minutes which should be long enough to run php scripts.";
		hitlessreload
		exit 0;
	fi

fi



## Should never reach this.
echo "We should never reach this part of our script. If we do, there is a major flaw in this script.";
exit 0;

