#!/bin/sh
HEADER() {
cat <<RESTVER

        startMalwareScan Version 1.1

RESTVER
}

SHOWHELP() {
cat <<EOHELP

  USAGE startMalwareScan.sh [ OPTIONS ]

  -a [ Action ]
    The acction we need to do.
  -j [ Job ID ]
    The Job ID from the database we need to use to update the report.
  -u [ Username ]
    The username for the malwarescan.
  -d [ Domain ]
    The domain from the user we need to scan.
  -q [ Quarantaine ]
    If we need to move the scanned files to quarantaine.
  -r [ Reportname ]
    The name we are using as a reportname
  -h [ Help ]
    This info.

EOHELP
exit
}

### Start getopts code ###
while getopts :a:j:u:d:q:r:l:h: FLAG
do
  case $FLAG in
    a)  ACTION="$OPTARG";;
    j)  SCAN_JOBID="$OPTARG";;
    u)  SCAN_USERNAME="$OPTARG";;
    d)  SCAN_DOMAIN="$OPTARG";;
    q)  SCAN_QUARANTAINE="$OPTARG";;
    r)  SCAN_REPORTNAME="$OPTARG";;
    l)  SERVER_MAX_LOAD="$OPTARG";;
    h)  SHOWHELP;;
    \?)  echo -e \\n"Option -$OPTARG not allowed."; exit;;
    *)  HEADER SHOWHELP;;
  esac
done
shift $((OPTIND-1))

if [ -z $ACTION ];then echo "Action is not set!"; SHOWHELP; fi
if [ -z $SCAN_JOBID ];then echo "JobID is not set!"; SHOWHELP; fi
if [ -z $SCAN_USERNAME ];then echo "Username is not set!"; SHOWHELP; fi
if [ -z $SCAN_DOMAIN ];then echo "Domain is not set!"; SHOWHELP; fi
if [ -z $SCAN_QUARANTAINE ];then echo "Quarantaine is not set!"; SHOWHELP; fi
if [ -z $SCAN_REPORTNAME ];then echo "Reportname is not set!"; SHOWHELP; fi
if [ -z $SERVER_MAX_LOAD ];then echo "No server maxload given!"; SHOWHELP; fi

echo "All variables accepted:"

cat <<EOACCEPT

        startMalwareScan All variables accepted:
        Action: $ACTION
        JobID: $SCAN_JOBID
        Username: $SCAN_USERNAME
        Domain: $SCAN_DOMAIN
        Quarantaine: $SCAN_QUARANTAINE
        Reportname: $SCAN_REPORTNAME
        MaxLoad: $SERVER_MAX_LOAD

EOACCEPT

LOADAVG=$(cat /proc/loadavg  | tr '.' ' ' | awk '{print$1}')
if [ "$LOADAVG" -lt "$SERVER_MAX_LOAD" ]
then
  /bin/sh /usr/local/sshdaemon/scripts/startMalwareScanPart2.sh -a $ACTION -j $SCAN_JOBID -u $SCAN_USERNAME -d $SCAN_DOMAIN -q $SCAN_QUARANTAINE -r $SCAN_REPORTNAME >> /dev/null 2>&1 &
fi
