#!/bin/bash
# _fixuserdomainpermissions.sh
USER=$1
DOMAIN=$2

if [ -z "$USER" ]
then
  echo "No user given!"
  echo "Exiting now..."
  exit
fi

if [ -z "$DOMAIN" ]
then
  echo "No domain variable given!"
  echo "Exiting now..."
  exit
fi

if [ -d "/home/$USER" ]
then
  if [ -d "/home/$USER/domains/$DOMAIN" ]
  then
    cd "/home/$USER/domains/$DOMAIN/public_html"
    if [ $(pwd) == "/home/$USER/domains/$DOMAIN/public_html" ]
    then
      echo "setting permissions...";
      chown -R $USER:$USER /home/$USER/domains/$DOMAIN/*
      find . -type d -print0 | xargs -0 chmod 755
      find . -type f -print0 | xargs -0 chmod 644
    else
      echo "public_html does not exist in /home/$USER/domains/$DOMAIN/"
      exit
    fi
  else
    echo "Domain dir does not exist in /home/$USER/domains/"
    exit
  fi
else
  echo "User homedir does not exist in /home/"
  exit
fi
