#!/bin/bash
# _fixdefaultuserfolders.sh
ACTION=$1
USER=$2

if [ -z $ACTION ]; then echo "No action has been given."; exit; fi
if [ -z $USER ]; then echo "No username has been given."; exit; fi

USERHOME="/home/$USER"
DOMLIST="/usr/local/directadmin/data/users/$USER/domains.list"

clean_user(){
  rm -fr /home/$USER/*
  rm -fr /home/$USER/.appdata
  rm -fr /home/$USER/.cagefs
  rm -fr /home/$USER/.cl.selector
  rm -fr /home/$USER/.php
  rm -fr /home/$USER/.pki
  rm -fr /home/$USER/.softaculous
}

create_default_dirs(){

if [[ -d "$USERHOME" ]]; then

  if [[ ! -d "$USERHOME/Maildir" ]]; then mkdir -p "$USERHOME/Maildir"; fi
  if [[ ! -d "$USERHOME/imap" ]]; then mkdir -p "$USERHOME/imap"; fi
  if [[ ! -d "$USERHOME/domains" ]]; then mkdir -p "$USERHOME/domains"; fi

  if [[ ! -s "$DOMLIST" ]]; then
    echo "User $USER has no domains added to their account."
    echo "Only creating $USERHOME/domains"
    mkdir -p "$USERHOME/domains"
    chown $USER. -R "$USERHOME/domains"
    chmod 711 "$USERHOME/domains/"

  else

    while read DOMAIN
    do
      echo "Creating domain dir $USERHOME/domains/$DOMAIN/public_html"
      if [[ ! -d "$USERHOME/domains/$DOMAIN" ]]; then mkdir -p "$USERHOME/domains/$DOMAIN/public_html"; fi
      chmod 711 "$USERHOME/domains/$DOMAIN"

      if [[ ! -f "$USERHOME/domains/$DOMAIN/public_html/index.php" ]]
      then
              echo "Creating a index.php to show the folder has been reset."
              echo '<?php echo "This domain has been reset"; ?> ' >> "$USERHOME"/domains/"$DOMAIN"/public_html/index.php
      else
              echo "A index.php exists. Skipping create of index.php"
      fi

      echo "Re-creating mailbox directory's if they exist."
      if [[ ! -d "$USERHOME/imap/$DOMAIN" ]]; then mkdir -p "$USERHOME/imap/$DOMAIN"; fi
      if [[ -f "/etc/virtual/$DOMAIN/passwd" ]]; then
        while read MAILBOX
        do
          if [ -z $MAILBOX ]; then break; fi
          MBOX=`echo $MAILBOX | awk -F":" '{print $1}'`
          if [[ ! -d "$USERHOME/imap/$DOMAIN/$MBOX" ]]; then mkdir -p "$USERHOME/imap/$DOMAIN/$MBOX/Maildir"; fi
        done < /etc/virtual/$DOMAIN/passwd
      fi

    done < $DOMLIST

  fi

  chown $USER. -R "$USERHOME/"
  chmod 711 "$USERHOME/domains/"
  /usr/local/directadmin/scripts/set_permissions.sh set_user_home "$USER"
  /usr/sbin/cagefsctl --cpetc "$USER"
  /usr/sbin/cagefsctl --remount "$USER"

else
  echo "Sorry, $USERHOME does not exist!"
  echo "Please enter a valid username."
  exit
fi

}

case $ACTION in
"clean")
  clean_user
  create_default_dirs
;;

"fix")
  create_default_dirs
;;

*)
  echo "$ACTION is not a valid action!"
  exit
;;
esac

echo "Done!"
